package gov.va.med.mhv.sm.admin.model;


import gov.va.med.mhv.sm.admin.enums.ParticipantTypeEnum;
import gov.va.med.mhv.sm.admin.enums.UserTypeEnum;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.DynamicUpdate;


@Entity
@DiscriminatorValue("0")
@DynamicUpdate(value=true)
public class SMPatient extends SMUser {

	private static final long serialVersionUID = 2L;

	public SMPatient(){
		super();
		this.userType = UserTypeEnum.PATIENT;
		this.participantType = ParticipantTypeEnum.PATIENT;
	}

	@Column(name = "DOB")
	@Temporal(TemporalType.TIMESTAMP)
	private Date dob;

	@Column(name = "ICN")
	private String icn;

	@Column(name = "NSSN")
	private String nssn;
	
	@Column(name = "RELATIONSHIP_UPDATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date relationshipUpdate;
	
	@Column(name = "SSN")
	private String ssn;

	public Date getDob() {
		return dob;
	}

	public void setDob(Date dob) {
		this.dob = dob;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public String getNssn() {
		return nssn;
	}

	public void setNssn(String nssn) {
		this.nssn = nssn;
	}

	public Date getRelationshipUpdate() {
		return relationshipUpdate;
	}

	public void setRelationshipUpdate(Date relationshipUpdate) {
		this.relationshipUpdate = relationshipUpdate;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
	
	

}
